/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.Watchable;
import ibm.nways.jdm.Watcher;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.LsBridgeConfig;
import ibm.nways.lspeed.LsLocalContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class LsBridgeView
implements GraphicPanelProducer,
Watcher {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private static String NlsBridgeConfigInProgressMessage = "BridgeConfigInProgressMessage";
    private static String NlsStartBridgeGraphic = "StartBridgeGraphic";
    private static String NlsEndBridgeGraphic = "EndBridgeGraphic";
    private ResourceBundle lspeedBundle;
    private GraphicPanel graphicPanel;
    private NavigationContext oldContext;
    private JdmBrowser parentJdm;
    private Image blockingImage;
    private Image forwardingImage;
    private LsBridgeConfig bridgeConfig;
    private boolean bridgeConfigHasChanged = false;
    private GenModel portModel;
    private Hashtable portGraphicsTable;
    private Thread portGraphicsBuilderThread;

    private static String Class_VBridgePanel() {
        return "ibm.nways.lspeed.VBridgePanel";
    }

    private static String Class_VBridgePortsPanel() {
        return "ibm.nways.lspeed.VBridgePortsPanel";
    }

    private static String Class_VBridgeUnassignedPortsPanel() {
        return "ibm.nways.lspeed.VBridgeUnassignedPortsPanel";
    }

    private static String NlsFlyOverPortIsForwarding() {
        return "FlyOverPortIsForwarding";
    }

    private static String NlsFlyOverPortIsBlocking() {
        return "FlyOverPortIsBlocking";
    }

    private static String HelpDirName() {
        return "ibm.nways.lspeed";
    }

    private static String HelpDocName() {
        return "ibm.nways.lspeed.VBridgeGraphic.html";
    }

    private ResourceBundle getLspeedBundle() {
        return this.lspeedBundle;
    }

    private JdmBrowser getParentJdm() {
        return this.parentJdm;
    }

    private Image getBlockingImage() {
        return this.blockingImage;
    }

    private Image getForwardingImage() {
        return this.forwardingImage;
    }

    private LsBridgeConfig getBridgeConfig() {
        return this.bridgeConfig;
    }

    private GenModel getDevicePortModel() {
        return this.portModel;
    }

    LsBridgeView(JdmBrowser jdmBrowser, LsBridgeConfig lsBridgeConfig) {
        this.parentJdm = jdmBrowser;
        this.portGraphicsTable = new Hashtable();
        this.blockingImage = this.parentJdm.imageFrom(this.parentJdm, "block.gif");
        this.forwardingImage = this.parentJdm.imageFrom(this.parentJdm, "forward.gif");
        GenModel genModel = (GenModel)jdmBrowser.getModel();
        try {
            this.portModel = (GenModel)genModel.getComponent("LsPort");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.lspeedBundle = ResourceBundle.getBundle(bundleName);
        this.bridgeConfig = lsBridgeConfig;
        lsBridgeConfig.addWatcher(this);
    }

    public GraphicPanel getGraphicFor(NavigationDestination navigationDestination, GraphicPanel graphicPanel, NavigationContext navigationContext) {
        this.oldContext = navigationContext;
        if (this.graphicPanel == null || this.bridgeConfigHasChanged) {
            this.parentJdm.displayMsg(this.lspeedBundle.getString("StartBridgeGraphic"));
            this.bridgeConfigHasChanged = false;
            this.graphicPanel = this.getBridgeGraphicPanel();
            this.parentJdm.displayMsg(this.lspeedBundle.getString("EndBridgeGraphic"));
        }
        return this.graphicPanel;
    }

    void dispose() {
        this.bridgeConfig.deleteWatcher(this);
        if (this.graphicPanel != null) {
            this.graphicPanel.dispose();
        }
        this.graphicPanel = null;
        if (this.portGraphicsTable != null) {
            Enumeration enumeration = this.portGraphicsTable.elements();
            while (enumeration.hasMoreElements()) {
                BridgePortGraphic bridgePortGraphic = (BridgePortGraphic)enumeration.nextElement();
                bridgePortGraphic.dispose();
            }
            this.portGraphicsTable.clear();
        }
    }

    public void update(Watchable watchable, Object object) {
        if (watchable == this.bridgeConfig) {
            this.bridgeConfigHasChanged = true;
            if (this.portGraphicsTable.isEmpty() && this.portGraphicsBuilderThread == null) {
                this.portGraphicsBuilderThread = new PortGraphicsBuilderThread();
                this.portGraphicsBuilderThread.start();
            }
            if (this.graphicPanel != null && this.graphicPanel.isShowing()) {
                this.parentJdm.setGraphicPanel(this.getGraphicFor(null, null, null));
            }
        }
    }

    private GraphicPanel getBridgeGraphicPanel() {
        GraphicPanel graphicPanel = null;
        BridgesView bridgesView = new BridgesView();
        Vector vector = this.bridgeConfig.getBridgesList();
        if (vector != null && vector.size() != 0) {
            System.out.println("Starting building bridge panel ...");
            long l = System.currentTimeMillis();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LsBridgeConfig.LsBridgeObject lsBridgeObject = (LsBridgeConfig.LsBridgeObject)enumeration.nextElement();
                bridgesView.addBridge(lsBridgeObject);
            }
            graphicPanel = new GraphicPanel(this.parentJdm, bridgesView);
            long l2 = System.currentTimeMillis();
            System.out.println("Finished building bridge panel ... " + String.valueOf(l2 - l) + " msecs");
        } else {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            Label label = new Label(this.lspeedBundle.getString(NlsBridgeConfigInProgressMessage));
            panel.add("Center", label);
            graphicPanel = new GraphicPanel(this.parentJdm, panel);
        }
        return graphicPanel;
    }

    private BridgePortGraphic getBridgePortGraphic(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
        Object object = this.portGraphicsTable.get(lsBridgePortObject.getKey());
        if (object == null) {
            object = new BridgePortGraphic(this.getParentJdm(), lsBridgePortObject);
            this.portGraphicsTable.put(lsBridgePortObject.getKey(), object);
        } else {
            ((BridgePortGraphic)object).updateBridgePortGraphic(lsBridgePortObject);
        }
        return (BridgePortGraphic)object;
    }

    private static int defaultThickness() {
        return 2;
    }

    private static int BridgePortLabelX() {
        return 3;
    }

    private static int BridgePortLabelY() {
        return 0;
    }

    private static int BridgePortImageX() {
        return 0;
    }

    private static int BridgePortImageY() {
        return 23;
    }

    private static int BridgePortStpImageX() {
        return 15;
    }

    private static int BridgePortStpImageY() {
        return 54;
    }

    final /* synthetic */ JdmBrowser access$0() {
        return this.getParentJdm();
    }

    final /* synthetic */ BridgePortGraphic access$2(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
        return this.getBridgePortGraphic(lsBridgePortObject);
    }

    final /* synthetic */ GenModel access$10() {
        return this.getDevicePortModel();
    }

    final /* synthetic */ Image access$11() {
        return this.getForwardingImage();
    }

    final /* synthetic */ ResourceBundle access$12() {
        return this.getLspeedBundle();
    }

    final /* synthetic */ Image access$14() {
        return this.getBlockingImage();
    }

    final /* synthetic */ LsBridgeConfig access$18() {
        return this.getBridgeConfig();
    }

    protected class BridgesView
    extends GraphicContainer {
        private GridBagLayout gbl = new GridBagLayout();
        private GridBagConstraints gbc;

        public BridgesView() {
            LsBridgeView.this = LsBridgeView.this;
            this.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.anchor = 18;
            this.gbc.fill = 0;
            this.gbc.gridx = 0;
            this.gbc.gridy = -1;
            HelpRef helpRef = new HelpRef(LsBridgeView.HelpDirName(), LsBridgeView.HelpDocName());
            GraphicHelp graphicHelp = new GraphicHelp(LsBridgeView.this.access$0(), new Point(0, 0), helpRef);
            this.gbl.setConstraints(graphicHelp, this.gbc);
            this.add(graphicHelp);
            this.gbc.anchor = 10;
            this.gbc.fill = 0;
            this.gbc.gridx = 0;
            this.gbc.gridy = -1;
        }

        public void addBridge(LsBridgeConfig.LsBridgeObject lsBridgeObject) {
            Object object;
            BridgeContainer bridgeContainer = new BridgeContainer(lsBridgeObject);
            Enumeration enumeration = lsBridgeObject.getBridgePorts().elements();
            while (enumeration.hasMoreElements()) {
                object = (LsBridgeConfig.LsBridgePortObject)enumeration.nextElement();
                bridgeContainer.addBridgePort((LsBridgeConfig.LsBridgePortObject)object);
            }
            object = " (" + lsBridgeObject.getBridgeId() + ")" + lsBridgeObject.getBridgeName();
            BridgeBox bridgeBox = new BridgeBox((Component)bridgeContainer, (String)object);
            this.gbl.setConstraints(bridgeBox, this.gbc);
            this.add(bridgeBox);
        }
    }

    protected class BridgeContainer
    extends Panel {
        private GridBagLayout gbl = new GridBagLayout();
        private GridBagConstraints gbc = new GridBagConstraints();

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width < 200) {
                dimension.width = 200;
            }
            if (dimension.height < 100) {
                dimension.height = 100;
            }
            return dimension;
        }

        public BridgeContainer(LsBridgeConfig.LsBridgeObject lsBridgeObject) {
            LsBridgeView.this = LsBridgeView.this;
            this.setLayout(this.gbl);
            GenModel genModel = null;
            int n = lsBridgeObject.getBridgeId();
            if (lsBridgeObject.hasValidId()) {
                genModel = lsBridgeObject.getBridgeExtsModel();
                NavigationContext navigationContext = new NavigationContext();
                LsLocalContext.setVBridgeInNavContext(navigationContext, new Integer(n));
                navigationContext.setParent(LsBridgeView.this.access$0().getNavigationTree().getNavContext());
                GraphicImage graphicImage = new GraphicImage(LsBridgeView.this.access$0().imageFrom(this, "bridge.gif"), new Point(0, 0), 0, new GraphicActionNavigate(LsBridgeView.this.access$0(), new NavigationDestination(LsBridgeView.Class_VBridgePanel(), genModel), navigationContext), null);
                graphicImage.setFlyOver(new GraphicFlyOver(lsBridgeObject.getBridgeName()));
                GraphicContainer graphicContainer = new GraphicContainer();
                graphicContainer.add(graphicImage);
                this.gbc.anchor = 11;
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.gridy = 0;
                this.gbc.insets = new Insets(3, 3, 3, 3);
                this.gbc.gridwidth = 0;
                this.gbc.gridheight = 1;
                this.gbl.setConstraints(graphicContainer, this.gbc);
                this.add(graphicContainer);
            }
            this.gbc.anchor = 11;
            this.gbc.fill = 0;
            this.gbc.insets = new Insets(3, 3, 3, 3);
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.gbc.gridwidth = 1;
        }

        public void addBridgePort(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            BridgePortGraphic bridgePortGraphic = LsBridgeView.this.access$2(lsBridgePortObject);
            this.gbl.setConstraints(bridgePortGraphic, this.gbc);
            this.add(bridgePortGraphic);
            ++this.gbc.gridx;
            if (this.gbc.gridx > 4) {
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
            }
        }
    }

    protected class BridgeBox
    extends Panel {
        private DrawnRectangle box;
        private Label titleLabel;
        private Component surrounded;

        public BridgeBox(Component component, String string) {
            this(component, new Label(string, 1));
        }

        public BridgeBox(Component component, Label label) {
            LsBridgeView.this = LsBridgeView.this;
            this.box = new DrawnRectangle(this);
            this.titleLabel = label;
            this.surrounded = component;
            this.box.setLineColor(Color.lightGray);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 11;
            gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
            this.add(this.titleLabel);
            gridBagConstraints.insets = new Insets(0, 3, 3, 3);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.add(component);
        }

        public void paint(Graphics graphics) {
            this.box.paint();
            super.paint(graphics);
        }

        public void setSize(int n, int n2) {
            this.setBounds(this.getLocation().x, this.getLocation().y, n, n2);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            FontMetrics fontMetrics = this.titleLabel.getFontMetrics(this.titleLabel.getFont());
            int n5 = this.getInsets().top + fontMetrics.getAscent();
            Dimension dimension = this.getSize();
            this.box.setBounds(0, n5, dimension.width - 1, dimension.height - n5 - 1);
        }

        protected String paramString() {
            return String.valueOf(super.paramString()) + ",tile=" + this.titleLabel;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            if (dimension.width < 200) {
                dimension.width = 200;
            }
            if (dimension.height < 100) {
                dimension.height = 100;
            }
            return dimension;
        }
    }

    protected class DrawnRectangle
    extends Rectangle {
        private Component drawInto;
        private int thick;
        private Color lineColor;
        private Color fillColor;

        public DrawnRectangle(Component component) {
            this(component, LsBridgeView.defaultThickness(), 0, 0, 0, 0);
        }

        public DrawnRectangle(Component component, int n) {
            this(component, n, 0, 0, 0, 0);
        }

        public DrawnRectangle(Component component, int n, int n2, int n3, int n4) {
            this(component, LsBridgeView.defaultThickness(), n, n2, n3, n4);
        }

        public DrawnRectangle(Component component, int n, int n2, int n3, int n4, int n5) {
            LsBridgeView.this = LsBridgeView.this;
            this.drawInto = component;
            this.thick = n;
            this.setBounds(n2, n3, n4, n5);
        }

        public Component component() {
            return this.drawInto;
        }

        public int getThickness() {
            return this.thick;
        }

        public void setThckness(int n) {
            this.thick = n;
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }

        public void setFillColor(Color color) {
            this.fillColor = color;
        }

        public void fill() {
            this.fill(this.getFillColor());
        }

        public Color getLineColor() {
            if (this.lineColor == null) {
                this.lineColor = this.drawInto.getBackground().darker().darker().darker();
            }
            return this.lineColor;
        }

        public Color getFillColor() {
            if (this.fillColor == null) {
                this.fillColor = this.drawInto.getBackground();
            }
            return this.fillColor;
        }

        public Rectangle getInnerBounds() {
            return new Rectangle(this.x + this.thick, this.y + this.thick, this.width - this.thick * 2, this.height - this.thick * 2);
        }

        public void paint() {
            Graphics graphics = this.drawInto.getGraphics();
            this.paintFlat(graphics, this.getLineColor());
        }

        public void paintFlat(Graphics graphics, Color color) {
            if (graphics != null) {
                graphics.setColor(color);
                int n = 0;
                while (n < this.thick) {
                    graphics.drawRect(this.x + n, this.y + n, this.width - n * 2 - 1, this.height - n * 2 - 1);
                    ++n;
                }
            }
        }

        public void clearInterior() {
            this.fill(this.drawInto.getBackground());
        }

        public void clearExterior() {
            this.paintFlat(this.drawInto.getGraphics(), this.drawInto.getBackground());
        }

        public void clear() {
            this.clearExterior();
            this.clearInterior();
        }

        public void fill(Color color) {
            Graphics graphics = this.drawInto.getGraphics();
            if (graphics != null) {
                Rectangle rectangle = this.getInnerBounds();
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.setFillColor(color);
            }
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[" + this.paramString() + "]";
        }

        public String paramString() {
            return "color=" + this.getLineColor() + ", thickness =" + this.thick + ", fillColor= " + this.getFillColor();
        }

        protected Color brighter() {
            return this.getLineColor().brighter().brighter().brighter().brighter();
        }
    }

    private class BridgePortGraphic
    extends GraphicContainer {
        private GraphicImage grImage;
        private int previousParentBridge = 257;
        private GraphicImage stpStateImage;
        private int previousStpState = 256;
        private Label titleLabel;

        BridgePortGraphic(JdmBrowser jdmBrowser, LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            LsBridgeView.this = LsBridgeView.this;
            this.grImage = new GraphicImage(jdmBrowser.imageFrom(jdmBrowser, "port.gif"), new Point(LsBridgeView.BridgePortImageX(), LsBridgeView.BridgePortImageY()), 1);
            this.add(this.grImage);
            this.titleLabel = new Label(lsBridgePortObject.getKey());
            this.titleLabel.setLocation(new Point(LsBridgeView.BridgePortLabelX(), LsBridgeView.BridgePortLabelY()));
            this.add(this.titleLabel);
            this.grImage.setStatus(lsBridgePortObject.getPortStatusProxy());
            Object[] objectArray = new Object[]{lsBridgePortObject.getKey(), lsBridgePortObject.getTranslatedPortType(), new Integer(lsBridgePortObject.getIfIndex())};
            String string = "Port: " + objectArray[0].toString() + " Type: " + objectArray[1].toString() + " Logical: " + objectArray[2].toString();
            this.grImage.setFlyOver(new GraphicFlyOver(string));
            this.updateBridgePortGraphic(lsBridgePortObject);
        }

        void updateBridgePortGraphic(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            Rectangle rectangle = this.titleLabel.getBounds();
            this.titleLabel.setBounds(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
            this.titleLabel.invalidate();
            this.titleLabel.validate();
            this.setDestination(lsBridgePortObject);
            this.setStpStateImage(lsBridgePortObject);
        }

        private void setDestination(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            if (lsBridgePortObject.getVBridgeId() == this.previousParentBridge) {
                return;
            }
            this.previousParentBridge = lsBridgePortObject.getVBridgeId();
            GraphicActionNavigate graphicActionNavigate = null;
            if (lsBridgePortObject.getBridgePortModel() != null) {
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.IfIndex", new Integer(lsBridgePortObject.getIfIndex()));
                NavigationContext navigationContext = new NavigationContext();
                NavInitialRow.setInitialRow(navigationContext, modelInfo);
                LsLocalContext.setVBridgeInNavContext(navigationContext, new Integer(lsBridgePortObject.getVBridgeId()));
                navigationContext.setParent(LsBridgeView.this.access$0().getNavigationTree().getNavContext());
                graphicActionNavigate = new GraphicActionNavigate(LsBridgeView.this.access$0(), new NavigationDestination(LsBridgeView.Class_VBridgePortsPanel(), lsBridgePortObject.getBridgePortModel()), navigationContext);
            } else {
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.Slot", new Integer(lsBridgePortObject.getSlot()));
                modelInfo.add("Index.Port", new Integer(lsBridgePortObject.getPort()));
                NavigationContext navigationContext = new NavigationContext();
                NavInitialRow.setInitialRow(navigationContext, modelInfo);
                navigationContext.setParent(LsBridgeView.this.access$0().getNavigationTree().getNavContext());
                graphicActionNavigate = new GraphicActionNavigate(LsBridgeView.this.access$0(), new NavigationDestination(LsBridgeView.Class_VBridgeUnassignedPortsPanel(), LsBridgeView.this.access$10()), navigationContext);
            }
            this.grImage.setAction(graphicActionNavigate);
        }

        private void setStpStateImage(LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            Image image = null;
            String string = null;
            if (this.previousStpState == lsBridgePortObject.getStpState()) {
                return;
            }
            this.previousStpState = lsBridgePortObject.getStpState();
            if (this.stpStateImage != null) {
                this.remove(this.stpStateImage);
            }
            if (lsBridgePortObject.getStpState() == 5) {
                image = LsBridgeView.this.access$11();
                string = LsBridgeView.this.access$12().getString(LsBridgeView.NlsFlyOverPortIsForwarding());
            }
            if (lsBridgePortObject.getStpState() == 2) {
                image = LsBridgeView.this.access$14();
                string = LsBridgeView.this.access$12().getString(LsBridgeView.NlsFlyOverPortIsBlocking());
            }
            if (image != null) {
                this.stpStateImage = new GraphicImage(image, new Point(LsBridgeView.BridgePortStpImageX(), LsBridgeView.BridgePortStpImageY()), 1);
                this.stpStateImage.setFlyOver(new GraphicFlyOver(string));
                this.add(this.stpStateImage);
                return;
            }
            this.stpStateImage = null;
        }
    }

    private class PortGraphicsBuilderThread
    extends Thread {
        public void run() {
            Vector vector = LsBridgeView.this.access$18().getBridgesList();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LsBridgeConfig.LsBridgeObject lsBridgeObject = (LsBridgeConfig.LsBridgeObject)enumeration.nextElement();
                    Enumeration enumeration2 = lsBridgeObject.getBridgePorts().elements();
                    while (enumeration2.hasMoreElements()) {
                        LsBridgeConfig.LsBridgePortObject lsBridgePortObject = (LsBridgeConfig.LsBridgePortObject)enumeration2.nextElement();
                        LsBridgeView.this.access$2(lsBridgePortObject);
                    }
                }
            }
        }

        PortGraphicsBuilderThread() {
            LsBridgeView.this = LsBridgeView.this;
        }
    }
}

